# 🧪 PAYROLL MODULE - TESTING GUIDE

## Quick Test Scenarios

### ✅ Scenario 1: Fresh Installation (No Data)
**Expected Behavior:**
- Dashboard shows $0.00 in all stats
- Empty state message appears with setup guide
- Shows "No Employees Found" warning if no employees exist
- Provides link to add employees

**How to Test:**
1. Navigate to: HR Management → Payroll → Dashboard
2. Verify empty state message displays
3. Click "Add Employees" button
4. Verify it redirects to employees page

---

### ✅ Scenario 2: Employees Exist, No Salary Structures
**Expected Behavior:**
- Dashboard shows $0.00 in all stats
- Empty state shows "Step 1: Configure Salary Structures"
- Provides link to salary structures tab

**How to Test:**
1. Add at least one employee
2. Navigate to: HR Management → Payroll → Dashboard
3. Verify setup guide shows salary structure step
4. Click "Set Up Salary Structures" button
5. Verify it redirects to salary structures tab

---

### ✅ Scenario 3: Salary Structures Configured, No Payroll Generated
**Expected Behavior:**
- Dashboard shows $0.00 in all stats
- Empty state shows "Step 2: Generate Payroll"
- Shows count of employees with salary structures
- Provides link to generate payroll tab

**How to Test:**
1. Configure salary structure for at least one employee
2. Navigate to: HR Management → Payroll → Dashboard
3. Verify it shows "X out of Y employees have salary structures"
4. Click "Generate Payroll Now" button
5. Verify it redirects to generate payroll tab

---

### ✅ Scenario 4: Payroll Generated Successfully
**Expected Behavior:**
- Dashboard shows actual payroll statistics
- No empty state message
- Stats cards show correct amounts
- Quick actions section visible

**How to Test:**
1. Generate payroll for at least one employee
2. Navigate to: HR Management → Payroll → Dashboard
3. Verify stats show non-zero values
4. Verify no empty state message appears
5. Verify quick actions cards are visible

---

### ✅ Scenario 5: Payroll History - No Records
**Expected Behavior:**
- Table shows enhanced empty state
- Message: "No Payroll Records Found"
- Provides link to generate payroll

**How to Test:**
1. Navigate to: HR Management → Payroll → Payroll History
2. Verify empty state message displays
3. Click "Generate Payroll" button
4. Verify it redirects correctly

---

### ✅ Scenario 6: Payroll History - With Month Filter
**Expected Behavior:**
- If no records for selected month, shows empty state
- Message includes selected month
- Provides "Clear Filter" button

**How to Test:**
1. Navigate to: HR Management → Payroll → Payroll History
2. Select a month with no payroll data
3. Click "Apply Filter"
4. Verify empty state shows month name
5. Verify "Clear Filter" button appears
6. Click "Clear Filter" and verify filter is removed

---

### ✅ Scenario 7: Database Table Missing
**Expected Behavior:**
- Shows error message: "Database Table Missing"
- Provides link to plugins page
- Suggests reactivating plugin

**How to Test:**
1. Temporarily rename `wp_hrm_payroll` table in database
2. Navigate to: HR Management → Payroll → Dashboard
3. Verify error message displays
4. Restore table name
5. Refresh page and verify it works

---

### ✅ Scenario 8: SQL Error Handling
**Expected Behavior:**
- Shows error message with SQL error details
- Prevents fatal errors
- Displays user-friendly message

**How to Test:**
1. Use diagnostic tool to check for SQL errors
2. Verify no PHP errors in error log
3. Check that queries use proper $wpdb->prepare()

---

### ✅ Scenario 9: Diagnostic Tool
**Expected Behavior:**
- All checks pass or show clear issues
- Provides actionable recommendations
- Quick fix buttons work

**How to Test:**
1. Access: `yoursite.com/wp-content/plugins/hr-management/debug_payroll_complete.php`
2. Verify all sections display
3. Check that table structure shows correctly
4. Verify AJAX handlers are registered
5. Test "Recreate Database Tables" button (if needed)

---

### ✅ Scenario 10: Salary Structure Management
**Expected Behavior:**
- Lists all employees
- Shows current salary info
- "Manage" button opens modal
- Can add allowances and deductions

**How to Test:**
1. Navigate to: HR Management → Payroll → Salary Structures
2. Verify employee list displays
3. Click "Manage" for an employee
4. Add allowances (e.g., HRA: 5000)
5. Add deductions (e.g., PF: 2000)
6. Save and verify success message
7. Refresh and verify data persists

---

### ✅ Scenario 11: Generate Payroll (Single Employee)
**Expected Behavior:**
- Shows all employees with attendance data
- "Run" button calculates payroll
- Shows success message
- Updates table with results

**How to Test:**
1. Navigate to: HR Management → Payroll → Generate Payroll
2. Select current month
3. Click "Run" for one employee
4. Verify loading indicator appears
5. Verify success toast message
6. Verify table updates with payroll data
7. Verify "View" and "Delete" buttons appear

---

### ✅ Scenario 12: Bulk Payroll Generation
**Expected Behavior:**
- Progress bar shows processing
- Processes all employees sequentially
- Shows completion message
- Reloads page with results

**How to Test:**
1. Navigate to: HR Management → Payroll → Generate Payroll
2. Click "Run Bulk Cycle"
3. Confirm the action
4. Verify progress bar appears
5. Verify progress percentage updates
6. Wait for completion
7. Verify page reloads with all payroll generated

---

### ✅ Scenario 13: View Payslip
**Expected Behavior:**
- Modal opens with payslip details
- Shows employee info, earnings, deductions
- Print button works
- Close button works

**How to Test:**
1. Generate payroll for an employee
2. Click "View" button
3. Verify modal opens
4. Verify payslip content displays
5. Click "Print Statement" (check print preview)
6. Click close button
7. Verify modal closes

---

### ✅ Scenario 14: Approve Payroll
**Expected Behavior:**
- Confirmation dialog appears
- Status changes to "Approved"
- Success message shows
- Page reloads

**How to Test:**
1. Navigate to: HR Management → Payroll → Payroll History
2. Find a draft payroll record
3. Click "Approve" button
4. Confirm the action
5. Verify success message
6. Verify status badge changes to "Approved"

---

### ✅ Scenario 15: Delete Payroll Record
**Expected Behavior:**
- Confirmation dialog appears
- Record is deleted
- Page reloads
- Record no longer visible

**How to Test:**
1. Navigate to: HR Management → Payroll → Generate Payroll
2. Find a payroll record
3. Click delete (trash) button
4. Confirm the action
5. Verify page reloads
6. Verify record is removed

---

## 🔍 Browser Console Checks

### No JavaScript Errors
Open browser console (F12) and verify:
- No red errors when loading payroll pages
- AJAX requests complete successfully
- No 404 errors for assets

### AJAX Response Validation
1. Open Network tab in browser dev tools
2. Perform an action (e.g., save salary structure)
3. Find the AJAX request
4. Verify response is `{"success":true,"data":"..."}`
5. Verify HTTP status is 200

---

## 📱 Responsive Testing

Test on different screen sizes:
- Desktop (1920x1080)
- Laptop (1366x768)
- Tablet (768x1024)
- Mobile (375x667)

Verify:
- Tables scroll horizontally on small screens
- Buttons are touch-friendly
- Modals are responsive
- Empty states display correctly
- No horizontal overflow

---

## 🔐 Security Testing

### Permission Checks
1. Log in as non-admin user
2. Try to access: `yoursite.com/wp-admin/admin.php?page=hrm-payroll`
3. Verify redirect to employee portal

### Nonce Validation
1. Open browser console
2. Try to submit AJAX request without nonce
3. Verify it's rejected with "Unauthorized" error

### SQL Injection Prevention
1. Try entering SQL in input fields: `'; DROP TABLE wp_hrm_payroll; --`
2. Verify it's sanitized and doesn't execute

---

## ✅ Final Checklist

- [ ] Empty state displays on fresh installation
- [ ] Setup guide shows correct steps based on state
- [ ] All action buttons work and redirect correctly
- [ ] Database error handling works
- [ ] SQL error handling works
- [ ] Diagnostic tool runs successfully
- [ ] Salary structures can be saved
- [ ] Single payroll generation works
- [ ] Bulk payroll generation works
- [ ] Payslip modal displays correctly
- [ ] Payroll approval works
- [ ] Payroll deletion works
- [ ] History tab shows records correctly
- [ ] Month filtering works in history
- [ ] Empty state in history works
- [ ] No JavaScript console errors
- [ ] No PHP errors in error log
- [ ] Responsive on all devices
- [ ] Security checks pass
- [ ] All AJAX endpoints respond correctly

---

## 🐛 Common Issues & Solutions

### Issue: "Database Table Missing" error
**Solution:** Deactivate and reactivate the plugin

### Issue: AJAX requests fail with 400 error
**Solution:** Check nonce is being sent correctly

### Issue: Payroll calculation shows $0.00
**Solution:** Verify salary structure is configured and attendance data exists

### Issue: Modal doesn't open
**Solution:** Check for JavaScript conflicts, verify jQuery is loaded

### Issue: Empty state doesn't show
**Solution:** Clear browser cache, verify latest code is deployed

---

**Last Updated:** <?php echo date('Y-m-d H:i:s'); ?>  
**Status:** Ready for Testing
